using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Resources;
using System.IO;

namespace ResXBuilder
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class RXBChildForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TreeView treeView1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;

		private String FFileName;
		private bool FModified;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem12;

		public RXBChildForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			Text = "Untitled";
			FFileName = "";
			FModified = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel2 = new System.Windows.Forms.Panel();
			this.label1 = new System.Windows.Forms.Label();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.treeView1 = new System.Windows.Forms.TreeView();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem9,
						this.menuItem1});
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 0;
			this.menuItem9.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem10,
						this.menuItem11});
			this.menuItem9.MergeType = System.Windows.Forms.MenuMerge.MergeItems;
			this.menuItem9.Text = "&File";
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 0;
			this.menuItem10.MergeOrder = 1;
			this.menuItem10.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
			this.menuItem10.Text = "&Save";
			this.menuItem10.Click += new System.EventHandler(this.menuItem10_Click);
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 1;
			this.menuItem11.MergeOrder = 1;
			this.menuItem11.Text = "Save As...";
			this.menuItem11.Click += new System.EventHandler(this.menuItem11_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 1;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem2,
						this.menuItem8,
						this.menuItem3});
			this.menuItem1.MergeOrder = 3;
			this.menuItem1.Text = "&Resource";
			this.menuItem1.Select += new System.EventHandler(this.menuItem1_Select);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem4,
						this.menuItem5,
						this.menuItem7});
			this.menuItem2.Text = "&Add";
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 0;
			this.menuItem4.Text = "&Bitmap...";
			this.menuItem4.Click += new System.EventHandler(this.menuItem4_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 1;
			this.menuItem5.Text = "&Icon...";
			this.menuItem5.Click += new System.EventHandler(this.menuItem5_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 2;
			this.menuItem7.Text = "Binar&y...";
			this.menuItem7.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 1;
			this.menuItem8.Text = "&Rename...";
			this.menuItem8.Click += new System.EventHandler(this.menuItem8_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 2;
			this.menuItem3.Text = "&Delete...";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Multiselect = true;
			this.openFileDialog1.Title = "Add Resource";
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 292);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
						this.statusBarPanel1});
			this.statusBar1.ShowPanels = true;
			this.statusBar1.Size = new System.Drawing.Size(472, 22);
			this.statusBar1.TabIndex = 4;
			this.statusBar1.Text = "statusBar1";
			this.statusBar1.Resize += new System.EventHandler(this.statusBar1_Resize);
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.MinWidth = 0;
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.panel2);
			this.panel1.Controls.Add(this.splitter1);
			this.panel1.Controls.Add(this.treeView1);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panel1.Location = new System.Drawing.Point(0, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(472, 292);
			this.panel1.TabIndex = 5;
			// 
			// panel2
			// 
			this.panel2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel2.Controls.Add(this.label1);
			this.panel2.Controls.Add(this.pictureBox1);
			this.panel2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panel2.Location = new System.Drawing.Point(195, 0);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(277, 292);
			this.panel2.TabIndex = 6;
			// 
			// label1
			// 
			this.label1.BackColor = System.Drawing.SystemColors.Info;
			this.label1.Location = new System.Drawing.Point(176, 52);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 64);
			this.label1.TabIndex = 7;
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// pictureBox1
			// 
			this.pictureBox1.BackColor = System.Drawing.SystemColors.Info;
			this.pictureBox1.Location = new System.Drawing.Point(80, 44);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(80, 72);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.CenterImage;
			this.pictureBox1.TabIndex = 6;
			this.pictureBox1.TabStop = false;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(192, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 292);
			this.splitter1.TabIndex = 3;
			this.splitter1.TabStop = false;
			// 
			// treeView1
			// 
			this.treeView1.BackColor = System.Drawing.SystemColors.Window;
			this.treeView1.ContextMenu = this.contextMenu1;
			this.treeView1.Dock = System.Windows.Forms.DockStyle.Left;
			this.treeView1.ImageIndex = -1;
			this.treeView1.LabelEdit = true;
			this.treeView1.Location = new System.Drawing.Point(0, 0);
			this.treeView1.Name = "treeView1";
			this.treeView1.SelectedImageIndex = -1;
			this.treeView1.Size = new System.Drawing.Size(192, 292);
			this.treeView1.TabIndex = 1;
			this.treeView1.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeView1_AfterSelect);
			this.treeView1.AfterLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(this.treeView1_AfterLabelEdit);
			this.treeView1.BeforeLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(this.treeView1_BeforeLabelEdit);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem6,
						this.menuItem12});
			this.contextMenu1.Popup += new System.EventHandler(this.contextMenu1_Popup);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 0;
			this.menuItem6.Text = "&Rename...";
			this.menuItem6.Click += new System.EventHandler(this.menuItem8_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 1;
			this.menuItem12.Text = "&Delete...";
			this.menuItem12.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.DefaultExt = "resx";
			this.saveFileDialog1.Filter = "ResX Files (*.resx)|*.resx|All Files (*.*)|*.*";
			// 
			// RXBChildForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(472, 314);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.statusBar1);
			this.Menu = this.mainMenu1;
			this.Name = "RXBChildForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.WindowsDefaultBounds;
			this.Text = "WinForm1";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.RXBChildForm_Closing);
			this.Load += new System.EventHandler(this.RXBChildForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		private bool itemNameExists(String itemName, TreeNode node)
		{
			for (int i = 0; i < node.Nodes.Count; i++)
			{
				if (node.Nodes[i].Text == itemName)
				{
					return true;
				}
			}
			return false;
		}

		private String createUniqueName(String itemName, TreeNode node)
		{
			if (itemNameExists(itemName, node))
			{
				int i = 1;
				String format = "{0}_{1}";
				while (itemNameExists(String.Format(format, itemName, i), node))
				{
					i++;
				}
				return String.Format(format, itemName, i);
			}
			else
			{
				return itemName;
			}
		}

		private void addResource(String itemName, System.Type itemType, object value)
		{
			TreeNode node = null;

			IEnumerator nodeList = treeView1.Nodes.GetEnumerator();
			while (nodeList.MoveNext())
			{
				if (((TreeNode)nodeList.Current).Text == itemType.ToString())
				{
				  node = (TreeNode)nodeList.Current;
				}
			}
			if (node == null)
			{
				node = treeView1.Nodes.Add(itemType.ToString());
				node = node.Nodes.Add(itemName);
			}
			else
			{
				node = node.Nodes.Add(createUniqueName(itemName, node));
			}
			node.Tag = value;
		}

		public void openFile(String fileName)
		{
			FFileName = fileName;
			Text = System.IO.Path.GetFileName(FFileName);

			ResXResourceReader Reader = new ResXResourceReader(fileName);
			IDictionaryEnumerator resList = Reader.GetEnumerator();

			while (resList.MoveNext())
			{
				addResource(resList.Key.ToString(), resList.Value.GetType(),
					resList.Value);
			}
		}

		public void saveFile()
		{
			saveFileAs(FFileName);
		}

		public void saveFileAs(String fileName)
		{
			IEnumerator parentList, nodeList;
			TreeNode node;

			ResXResourceWriter Writer = new ResXResourceWriter(fileName);
			parentList = treeView1.Nodes.GetEnumerator();
			while (parentList.MoveNext())
			{
				nodeList = ((TreeNode)parentList.Current).Nodes.GetEnumerator();
				while (nodeList.MoveNext())
				{
					node = (TreeNode)nodeList.Current;
					if (node.Tag != null)
					{
						Writer.AddResource(node.Text, node.Tag);
					}
				}
			}
			Writer.Close();
			FFileName = fileName;
			Text = System.IO.Path.GetFileName(FFileName);
			FModified = false;
		}

		private void treeView1_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			TreeNode node;
			System.Type tagType;

			pictureBox1.Image = null;
			node = ((TreeView)sender).SelectedNode;
			if (node != null)
			{
				if (node.Tag != null)
				{
					statusBarPanel1.Text = "";
					tagType = node.Tag.GetType();
					if (tagType.IsSubclassOf(typeof(System.Drawing.Image)))
					{
						pictureBox1.Image = (System.Drawing.Bitmap)(node).Tag;
						pictureBox1.BringToFront();
						return;
					}
					if (tagType == (typeof(System.Drawing.Icon)))
					{
						pictureBox1.Image = ((System.Drawing.Icon)(node).Tag).ToBitmap();
						pictureBox1.BringToFront();
						return;
					}
					String type = node.Tag.ToString();
					if (type != tagType.ToString())
					{
						label1.Text = type;
					}
					else
					{
						label1.Text = tagType.ToString();
					}
					label1.BringToFront();
				}
				else
				{
					String format = "{0}: {1} item(s)";
					statusBarPanel1.Text = String.Format(format, node.Text, node.Nodes.Count);
				}
			}
		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			String errorMessage = "Unable to add image '%s'.";

			openFileDialog1.FileName = "";
			openFileDialog1.Filter = "Images (*.bmp;*.png;*.jpg)|*.bmp;*.png;*.jpg|All Files (*.*)|*.*";
			openFileDialog1.DefaultExt = "bmp";
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				for (int i = 0; i < openFileDialog1.FileNames.Length; i++)
				{
					String resName = System.IO.Path.GetFileName(openFileDialog1.FileNames[i]);
					try
					{
						System.Drawing.Image image = System.Drawing.Image.FromFile(openFileDialog1.FileNames[i]);
						addResource(resName, image.GetType(), image);
					}
					catch
					{
						errorMessage = errorMessage.Replace("%s", openFileDialog1.FileNames[i]);
						MessageBox.Show(errorMessage, "Error", MessageBoxButtons.OK);
					}
				}
			}
			FModified = true;
		}

		private void menuItem1_Select(object sender, System.EventArgs e)
		{
			menuItem3.Enabled = (treeView1.SelectedNode != null);
			menuItem8.Enabled = (treeView1.SelectedNode != null) &&
								(treeView1.SelectedNode.Tag != null);
		}

		private void menuItem8_Click(object sender, System.EventArgs e)
		{
			treeView1.SelectedNode.BeginEdit();
		}

		private void treeView1_BeforeLabelEdit(object sender, System.Windows.Forms.NodeLabelEditEventArgs e)
		{
			if (e.Node.Tag == null)
			{
				e.CancelEdit = true;
			}
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			String errorMessage = "Unable to add icon '%s'.";

			openFileDialog1.FileName = "";
			openFileDialog1.Filter = "Icons (*.ico)|*.ico|All Files (*.*)|*.*";
			openFileDialog1.DefaultExt = "ico";
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				for (int i = 0; i < openFileDialog1.FileNames.Length; i++)
				{
					String resName = System.IO.Path.GetFileName(openFileDialog1.FileNames[i]);

					try
					{
						System.Drawing.Icon icon = new System.Drawing.Icon(openFileDialog1.FileNames[i]);
						addResource(resName, icon.GetType(), icon);
					}
					catch
					{
						errorMessage = errorMessage.Replace("%s", openFileDialog1.FileNames[i]);
						MessageBox.Show(errorMessage, "Error", MessageBoxButtons.OK);
					}
				}
			}
			FModified = true;
		}

		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			String message;
			DialogResult result;
			System.Type tagType;

			String deleteItem = "Are you sure you want to delete the resource '%s'?";
			String deleteGroup = "Are you sure you want to delete all resources of type '%s'?";
			TreeNode node = treeView1.SelectedNode;

			if (node.Tag == null)
			{
				message = deleteGroup.Replace("%s", node.Text);
			}
			else
			{
				message = deleteItem.Replace("%s", node.Text);
			}

			result = MessageBox.Show(message, "Delete Resource", MessageBoxButtons.YesNo);
			if (result == DialogResult.Yes)
			{
				node.Remove();
				tagType = node.Tag.GetType();
				if (!tagType.IsSubclassOf(typeof(System.Drawing.Image)))
				{
					label1.Text = "";
				}

				node = treeView1.SelectedNode;
				if (node != null)
				{
					if (node.Tag == null)
					{
						if (node.Nodes.Count == 0)
						{
							statusBarPanel1.Text = "";
							node.Remove();
						}
					}
					else
					{
						treeView1_AfterSelect(treeView1, null);
					}
				}
			}
			FModified = true;
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			String errorMessage = "Unable to add resource '%s'.";

			openFileDialog1.FileName = "";
			openFileDialog1.Filter = "All Files (*.*)|*.*";
			openFileDialog1.DefaultExt = "";
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				for (int i = 0; i < openFileDialog1.FileNames.Length; i++)
				{
					String resName = System.IO.Path.GetFileName(openFileDialog1.FileNames[i]);
					try
					{
						FileStream stream = new FileStream(openFileDialog1.FileNames[i],
							FileMode.Open, FileAccess.Read);
						Byte[] buffer = (Byte[])System.Array.CreateInstance(typeof(Byte), stream.Length);
						stream.Read(buffer, 0, buffer.Length);
						addResource(resName, buffer.GetType(), buffer);
					}
					catch
					{
						errorMessage = errorMessage.Replace("%s", openFileDialog1.FileNames[i]);
						MessageBox.Show(errorMessage, "Error", MessageBoxButtons.OK);
					}
				}
			}
			FModified = true;
		}

		private void RXBChildForm_Load(object sender, System.EventArgs e)
		{
			label1.Dock = DockStyle.Fill;
			pictureBox1.Dock = DockStyle.Fill;
		}

		private void statusBar1_Resize(object sender, System.EventArgs e)
		{
			statusBarPanel1.Width = statusBar1.Width;
		}

		private void menuItem10_Click(object sender, System.EventArgs e)
		{
			if (FFileName == "")
			{
				menuItem11_Click(sender, e);
			}
			else
			{
				saveFile();
			}
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			saveFileDialog1.FileName = "";
			if (saveFileDialog1.ShowDialog() == DialogResult.OK)
			{
				saveFileAs(saveFileDialog1.FileName);
			}
		}

		private void RXBChildForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (FModified)
			{

				DialogResult result;

				result = MessageBox.Show(String.Format("Save changes to {0}?", Text),
					"Confirm", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
				switch (result)
				{
					case DialogResult.No:
						return;
					case DialogResult.Cancel:
						e.Cancel = true;
						return;
				}
				menuItem10_Click(null, null);
				e.Cancel = FModified;
			}
		}

		private void treeView1_AfterLabelEdit(object sender, System.Windows.Forms.NodeLabelEditEventArgs e)
		{
			if (e.Label != null)
			{
				FModified = !itemNameExists(e.Label, treeView1.SelectedNode.Parent);
				if (!FModified)
				{
					MessageBox.Show("Resource name already exists.", "Error",
						MessageBoxButtons.OK, MessageBoxIcon.Error);
					e.CancelEdit = true;
				}
			}
		}
		
		private void contextMenu1_Popup(object sender, System.EventArgs e)
		{
			menuItem12.Enabled = (treeView1.SelectedNode != null);
			menuItem6.Enabled = (treeView1.SelectedNode != null) &&
								(treeView1.SelectedNode.Tag != null);
		}
	}
}
